<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\ResetsPasswords;
use Illuminate\Support\Facades\Auth;

class ResetPasswordController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Password Reset Controller
    |--------------------------------------------------------------------------
    |
    | This controller is responsible for handling password reset requests
    | and uses a simple trait to include this behavior. You're free to
    | explore this trait and override any methods you wish to tweak.
    |
    */

    use ResetsPasswords;

    /**
     * Where to redirect users after resetting their password.
     *
     * @var string
     */
    protected $redirectTo = '/';
    public function redirectTo()
    {
        switch (Auth::user()->role) {
            case 0:
                return $this->redirectTo = '/admin';
                break;
            case 1:
                return $this->redirectTo = '/trainer';
                break;
            case 2:
                return $this->redirectTo = '/student';
                break;
            case 3:
                return $this->redirectTo = '/coordinator';
                break;

            default:
                return $this->redirectTo;
                break;
        }
    }
}
